//texture tex0 < string name = "C:\\Active Projects\\eu3\\game\\gfx\\test\\testred.dds"; >;	// Base texture

float4x4 WorldViewProjectionMatrix; 
float CurrentState;
float4 vFirstColor;
float4 vSecondColor;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};

struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float3 vTexCoord  : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float3  vTexCoord0 : TEXCOORD0;
};


VS_OUTPUT VertexShader_(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
   	Out.vPosition  = mul(v.vPosition, WorldViewProjectionMatrix );
	
	Out.vTexCoord0  = v.vTexCoord;

	return Out;
}

float4 PixelShader_( VS_OUTPUT v ) : COLOR
{
	float4 TrueColor = vFirstColor;
	float4 OutColor = vSecondColor;
	
	if( v.vTexCoord0.x < CurrentState )
		OutColor = TrueColor;

  	return OutColor;
}

technique tec0
{
	pass p0
	{
//TODO		fvf = XYZ | Tex1;

		LightEnable[0] = false;
		LightingEnable = false;

		BlendEnable = true;

//TODO		TextureRectangle[0] = <tex0>;

//TODO		ColorOp[0] = Modulate;
//TODO		ColorArg1[0] = Texture;
//TODO		ColorArg2[0] = Current;
  
//TODO		ColorOp[1] = Disable;
//TODO		AlphaOp[1] = Disable;

		VertexProgram = compile arbvp1 VertexShader_();
		FragmentProgram = compile arbfp1 PixelShader_();
	}
}
